/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.lang.reflect.Constructor;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.rosuda.deducer.widgets.VariableSelectorWidget;
import org.rosuda.deducer.widgets.param.ParamWidget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Param
implements Cloneable {
    public static final String VIEW_ENTER = "org.rosuda.deducer.widgets.param.ParamTextFieldWidget";
    public static final String VIEW_ENTER_LONG = "org.rosuda.deducer.widgets.param.ParamTextFieldLongWidget";
    public static final String VIEW_COMBO = "org.rosuda.deducer.widgets.param.ParamComboBoxWidget";
    public static final String VIEW_EDITABLE_COMBO = "org.rosuda.deducer.widgets.param.ParamEditableComboBoxWidget";
    public static final String VIEW_CHECK_BOX = "org.rosuda.deducer.widgets.param.ParamCheckBoxWidget";
    public static final String VIEW_VECTOR_BUILDER = "org.rosuda.deducer.widgets.param.ParamVectorBuilderWidget";
    public static final String VIEW_TWO_VALUE_ENTER = "org.rosuda.deducer.widgets.param.ParamTwoValueWidget";
    public static final String VIEW_COLOR = "org.rosuda.deducer.widgets.param.ParamColorWidget";
    public static final String VIEW_RFUNCTION_CHOOSER = "org.rosuda.deducer.widgets.param.RFunctionListChooserWidget";
    public static final String VIEW_RFUNCTION_PANEL = "org.rosuda.deducer.widgets.param.RFunctionListPanelWidget";
    public static final String VIEW_SINGLE_VARIABLE = "org.rosuda.deducer.widgets.param.ParamVariableView";
    public static final String VIEW_HIDDEN = "org.rosuda.deducer.widgets.param.ParamNullWidget";
    public static final String VIEW_MULTI_VARIABLE = "org.rosuda.deducer.widgets.param.ParamMultipleVariablesWidget";
    public static final String VIEW_ROBJECT_COMBO = "org.rosuda.deducer.widgets.param.ParamRObjectComboBoxWidget";
    protected String name;
    protected String title;
    protected String[] options;
    protected String[] labels;
    protected String view = "org.rosuda.deducer.widgets.param.ParamTextFieldLongWidget";
    protected Double lowerBound;
    protected Double upperBound;
    protected boolean required = true;
    protected boolean requiresVariableSelector = false;

    public Param() {
    }

    public Param(String string) {
        this.setName(string);
        this.setTitle(string);
    }

    public ParamWidget getView() {
        try {
            Class<?> clazz = Class.forName(this.view);
            Constructor<?> constructor = clazz.getConstructor(Param.class);
            ParamWidget paramWidget = (ParamWidget)constructor.newInstance(this);
            return paramWidget;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public ParamWidget getView(VariableSelectorWidget variableSelectorWidget) {
        try {
            Class<?> clazz = Class.forName(this.view);
            Constructor<?> constructor = clazz.getConstructor(Param.class, VariableSelectorWidget.class);
            ParamWidget paramWidget = (ParamWidget)constructor.newInstance(this, variableSelectorWidget);
            return paramWidget;
        }
        catch (Exception exception) {
            return this.getView();
        }
    }

    public abstract Object clone();

    public abstract String[] getParamCalls();

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public abstract void setDefaultValue(Object var1);

    public abstract Object getDefaultValue();

    public void setViewType(String string) {
        this.view = string;
    }

    public String getViewType() {
        return this.view;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setOptions(String[] stringArray) {
        this.options = stringArray;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void setLabels(String[] stringArray) {
        this.labels = stringArray;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setLowerBound(Double d) {
        this.lowerBound = d;
    }

    public void setLowerBound(double d) {
        this.lowerBound = new Double(d);
    }

    public Double getLowerBound() {
        return this.lowerBound;
    }

    public void setUpperBound(Double d) {
        this.upperBound = d;
    }

    public void setUpperBound(double d) {
        this.upperBound = new Double(d);
    }

    public Double getUpperBound() {
        return this.upperBound;
    }

    public boolean requiresVariableSelector() {
        return this.requiresVariableSelector;
    }

    public void setRequiresVariableSelector(boolean bl) {
        this.requiresVariableSelector = bl;
    }

    public Element toXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("Param");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.title != null) {
                element.setAttribute("title", this.title);
            }
            if (this.view != null) {
                element.setAttribute("viewType", this.getViewType());
            }
            element.setAttribute("required", this.required ? "true" : "false");
            element.setAttribute("requiresVariableSelector", this.requiresVariableSelector ? "true" : "false");
            Element element2 = document.createElement("options");
            if (this.options != null) {
                for (int i = 0; i < this.options.length; ++i) {
                    element2.setAttribute("element_" + i, this.options[i]);
                }
            }
            element.appendChild(element2);
            Element element3 = document.createElement("labels");
            if (this.labels != null) {
                for (int i = 0; i < this.labels.length; ++i) {
                    element3.setAttribute("element_" + i, this.labels[i]);
                }
            }
            element.appendChild(element3);
            if (this.lowerBound != null) {
                element.setAttribute("lowerBound", this.lowerBound.toString());
            }
            if (this.upperBound != null) {
                element.setAttribute("upperBound", this.upperBound.toString());
            }
            document.appendChild(element);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setFromXML(Element element) {
        NamedNodeMap namedNodeMap;
        int n;
        NamedNodeMap namedNodeMap2;
        this.name = element.hasAttribute("name") ? element.getAttribute("name") : null;
        this.title = element.hasAttribute("title") ? element.getAttribute("title") : null;
        this.view = element.hasAttribute("viewType") ? element.getAttribute("viewType") : VIEW_ENTER_LONG;
        this.required = element.hasAttribute("required") ? element.getAttribute("required").equals("true") : false;
        this.requiresVariableSelector = element.hasAttribute("requiresVariableSelector") ? element.getAttribute("requiresVariableSelector").equals("true") : false;
        Node node = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element) || !((Element)nodeList.item(i)).getTagName().equals("options")) continue;
            node = nodeList.item(i);
        }
        if (node != null && (namedNodeMap2 = node.getAttributes()).getLength() > 0) {
            this.options = new String[namedNodeMap2.getLength()];
            for (n = 0; n < namedNodeMap2.getLength(); ++n) {
                this.options[n] = namedNodeMap2.item(n).getNodeValue();
            }
        }
        Node node2 = null;
        for (n = 0; n < nodeList.getLength(); ++n) {
            if (!(nodeList.item(n) instanceof Element) || !((Element)nodeList.item(n)).getTagName().equals("labels")) continue;
            node2 = nodeList.item(n);
        }
        if (node2 != null && (namedNodeMap = node2.getAttributes()).getLength() > 0) {
            this.labels = new String[namedNodeMap.getLength()];
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                this.labels[i] = namedNodeMap.item(i).getNodeValue();
            }
        }
        this.lowerBound = element.hasAttribute("lowerBound") ? new Double(Double.parseDouble(element.getAttribute("lowerBound"))) : null;
        this.upperBound = element.hasAttribute("upperBound") ? new Double(Double.parseDouble(element.getAttribute("upperBound"))) : null;
    }

    public static Param makeParam(String string) {
        Param param;
        try {
            param = (Param)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return param;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean hasValidEntry() {
        return true;
    }
}

