/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.AddButton;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.RemoveButton;
import org.rosuda.deducer.widgets.DeducerWidget;
import org.rosuda.deducer.widgets.VariableSelectorWidget;

public class VariableListWidget
extends JPanel
implements DeducerWidget,
ActionListener {
    private AddButton addButton;
    private JScrollPane listScrollPane;
    private DJList varList;
    private JPanel buttonPanel;
    private JPanel listPanel;
    private RemoveButton removeButton;
    private VariableSelectorWidget selector;
    private String title;
    private DefaultListModel initialModel;
    private DefaultListModel lastModel;

    public VariableListWidget(String string, VariableSelectorWidget variableSelectorWidget) {
        this.selector = variableSelectorWidget;
        this.title = string;
        this.selector.getJComboBox().addActionListener(this);
        this.initGUI();
    }

    public VariableListWidget(VariableSelectorWidget variableSelectorWidget) {
        this(null, variableSelectorWidget);
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(239, 136));
            this.listPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.add((Component)this.listPanel, new AnchorConstraint(0, 1002, 1003, 64, 2, 1, 1, 2));
            this.listPanel.setPreferredSize(new Dimension(184, 136));
            this.listPanel.setLayout(borderLayout);
            if (this.title != null) {
                this.listPanel.setBorder(BorderFactory.createTitledBorder(this.title));
            }
            this.listScrollPane = new JScrollPane();
            this.listPanel.add((Component)this.listScrollPane, "Center");
            this.varList = new DJList();
            this.listScrollPane.setViewportView(this.varList);
            this.varList.setModel(new DefaultListModel());
            this.buttonPanel = new JPanel();
            this.add((Component)this.buttonPanel, new AnchorConstraint(275, 140, 768, 2, 1, 0, 0, 1));
            this.buttonPanel.setPreferredSize(new Dimension(37, 81));
            this.buttonPanel.setLayout(null);
            this.addButton = new AddButton("Add", this.selector, (JList)this.varList);
            this.buttonPanel.add(this.addButton);
            this.addButton.setBounds(0, 0, 32, 34);
            this.removeButton = new RemoveButton("Remove", this.selector, (JList)this.varList);
            this.buttonPanel.add(this.removeButton);
            this.removeButton.setBounds(0, 42, 32, 34);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "comboBoxChanged") {
            this.varList.setModel(new DefaultListModel());
        }
    }

    public String[] getItems() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        Object[] objectArray = defaultListModel.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof String)) continue;
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public void setModel(String[] stringArray, boolean bl) {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            defaultListModel.addElement(stringArray[i]);
        }
        this.setModel(defaultListModel, bl);
    }

    public void setModel(DefaultListModel defaultListModel, boolean bl) {
        if (bl && this.selector == null) {
            this.setModel(defaultListModel, false);
        } else {
            if (defaultListModel == null) {
                defaultListModel = new DefaultListModel();
            }
            DefaultListModel defaultListModel2 = new DefaultListModel();
            for (int i = 0; i < defaultListModel.size(); ++i) {
                if (bl) {
                    boolean bl2 = this.selector.remove(defaultListModel.get(i));
                    if (!bl2) continue;
                    defaultListModel2.addElement(defaultListModel.get(i));
                    continue;
                }
                defaultListModel2.addElement(defaultListModel.get(i));
            }
            this.varList.setModel(defaultListModel2);
        }
    }

    public void addListener(EventListener eventListener) {
        if (eventListener instanceof ActionListener) {
            this.removeButton.addActionListener((ActionListener)eventListener);
            this.addButton.addActionListener((ActionListener)eventListener);
        }
        if (eventListener instanceof ListSelectionListener) {
            this.varList.addListSelectionListener((ListSelectionListener)eventListener);
        }
        if (eventListener instanceof MouseListener) {
            this.varList.addMouseListener((MouseListener)eventListener);
        }
    }

    public Object getModel() {
        return this.varList.getModel();
    }

    public String getRModel() {
        String string = Deducer.makeRCollection(this.varList.getModel(), "c", true);
        return string;
    }

    public String getTitle() {
        return this.title;
    }

    public void reset() {
        this.setModel(this.initialModel);
    }

    public void resetToLast() {
        this.setModel(this.lastModel);
    }

    public void setDefaultModel(Object object) {
        this.initialModel = (DefaultListModel)object;
        if (this.lastModel == null) {
            this.lastModel = (DefaultListModel)object;
        }
    }

    public void setLastModel(Object object) {
        this.lastModel = (DefaultListModel)object;
    }

    public void setModel(Object object) {
        this.setModel((DefaultListModel)object, true);
    }

    public void setTitle(String string, boolean bl) {
        this.title = string;
        if (string == null) {
            this.listPanel.setBorder(BorderFactory.createEmptyBorder());
        } else if (bl) {
            this.listPanel.setBorder(BorderFactory.createTitledBorder(this.title));
        }
    }

    public void setTitle(String string) {
        this.setTitle(string, false);
    }
}

