% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetProblemType.R
\name{GetProblemType}
\alias{GetProblemType}
\title{Get problem type function}
\usage{
GetProblemType(M1, k)
}
\arguments{
\item{M1}{Matrix. Matrix reduced.}

\item{k}{Integer. Size of the problem.}
}
\description{
This function apply TestType function multiple times, to be able of determine the type of problems between following
1.0 = Matrix size 0
1.1 = Matrix size 1
2.0 = Matrix size 2 where a marginal row or column equal 0
2.1 = Matrix size 2 and diagonal
2.2 = Matrix size 2 not diagonal
3.0 = Matrix size greater than 2 with a marginal row or column equal 0
3.1 = Matrix size greater than 2 and diagonal
3.2 = Matrix size greater than 2 with k-1 row or columns with marginal equal to a_{ii} or k-2 where marginals of columns and rows equals to a_{ii}
3.3 = Matrix size greater than 2 with h where Xt - sum(diag(M1)) = Xr[h] + Xc[h] - 2 * M1[h,h]
3.4 = Matrix size greater than 2 with i where a_{ii} = 0 or with marginals by columns or row equals to zero
3.5 = Matrix size greater than 2 without a_{ii} = 0 or without marginals by columns or row equals to zero
}
\examples{
GetProblemType(matrix(c(1,2,0,3,4,0,0,0,1),3,3), 3)
GetProblemType(matrix(c(1,0,0,0,2,0,0,0,3),3,3), 3)
}
\keyword{M1}
\keyword{k}
