% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustColWidths.R
\name{nchar_lf}
\alias{nchar_lf}
\title{Number of Characters Acknowledging Line Feed}
\usage{
nchar_lf(x, linefeed = TRUE)
}
\arguments{
\item{x}{An R object convertible to \code{\link[base]{character}}}

\item{linefeed}{\code{\link[base]{logical}} scalar, whether to recognize the line feed in counting
number of characters.  Default \code{TRUE}}
}
\value{
\code{\link{nchar_lf}} returns an \code{\link[base]{integer}} scalar or vector, 
the number of characters in each element of the input.
}
\description{
Finds the number of characters, similar to \code{\link[base]{nchar}}, 
while acknowledging the line feed \code{'\\n'}
}
\examples{

nchar_lf(character()) # 0L
x = c('aa\nb', '', NA, '\n', 'cef\ncd', 'abc')
nchar_lf(x, linefeed = TRUE)
nchar_lf(x, linefeed = FALSE)
nchar_lf(c(TRUE, FALSE, NA))
nchar_lf(c(12, 3, 467))

}
