% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadData.R
\name{split_redcap_dataset}
\alias{split_redcap_dataset}
\title{Split a dataset imported from Redcap into convenient subsets}
\usage{
split_redcap_dataset(dat, id_name = "patid")
}
\arguments{
\item{dat}{a \code{tibble} produced by \code{\link{read_redcap_formatted}}.}

\item{id_name}{(character) the name of the subject ID variable.}
}
\value{
a list of datasets separated into the categories as described
}
\description{
This function seperates a datasets into three parts: "Singular" data, which is the
data from non-repeating instruments. "missings_everywhere", which is data which is missing for each row.
The last parts are all the repeating instruments, which are referred to by their name as recorded in
\code{dat$redcap_repeat_instrument}.
}
\examples{
path_to_redcap_script <- system.file("examples", "testredcap.r", package = "DescrTab2")
dat <- read_redcap_formatted(path_to_redcap_script)
d <- split_redcap_dataset(dat, guess_ID_variable(dat, TRUE))
}
