% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cmty_louvain.R
\name{get_cmty_louvain}
\alias{get_cmty_louvain}
\title{Get community membership by Louvain optimization}
\usage{
get_cmty_louvain(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame with group membership
assignments for each of the nodes.
}
\description{
Through the use of multi-level
optimization of a modularity score, obtain the
group membership values for each of the nodes in
the graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    10, 22, set_seed = 23)

# Get the group membership values for all nodes
# in the graph through the multi-level optimization
# of modularity algorithm
get_cmty_louvain(graph)
#>    id louvain_group
#> 1   1             2
#> 2   2             1
#> 3   3             1
#> 4   4             2
#> 5   5             2
#> 6   6             2
#> 7   7             1
#> 8   8             2
#> 9   9             1
#> 10 10             2

# Add the group membership values to the graph
# as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(get_cmty_louvain(.))
}

