% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_info.R
\name{graph_info}
\alias{graph_info}
\title{Get metrics for a graph}
\usage{
graph_info(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame containing metrics pertaining
to the graph
}
\description{
Get a data frame with metrics for a
graph.
}
\examples{
\dontrun{
# Import a GraphML graph file available in the
# DiagrammeR package
karate_club <-
  system.file(
    "extdata", "karate.gml",
    package = "DiagrammeR") \%>\%
  import_graph() \%>\%
  set_graph_name("karate")

# Display a data frame with graph information
graph_info(karate_club)
#>     name  n  e  dens mn_deg mx_deg avg_deg time   tz
#> 1 karate 34 78 0.139      1     17       5 <NA> <NA>
}
}

