% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_degree_out.R
\name{get_degree_out}
\alias{get_degree_out}
\title{Get outdegree values for all nodes}
\usage{
get_degree_out(graph, normalized = FALSE)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{normalized}{set as \code{FALSE} (the default),
the outdegree will be provided for each of
the nodes (as a count of edges outgoing from each node).
When set as \code{TRUE}, then the result for each node
will be divided by the total number of nodes in the
graph minus 1.}
}
\value{
a data frame with outdegree values for
each of the nodes.
}
\description{
Get the outdegree values for all
nodes in a graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Get the outdegree values for all nodes
# in the graph
get_degree_out(graph)
#>    id outdegree
#> 1   1         4
#> 2   2         5
#> 3   3         3
#> 4   4         3
#> 5   5         2
#> 6   6         3
#> 7   7         1
#> 8   8         0
#> 9   9         1
#> 10 10         0

# Add the outdegree values to the graph
# as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_degree_out(.))

# Display the graph's node data frame
get_node_df(graph)
#>    id type label value outdegree
#> 1   1 <NA>     1   6.0         4
#> 2   2 <NA>     2   2.5         5
#> 3   3 <NA>     3   3.5         3
#> 4   4 <NA>     4   7.5         3
#> 5   5 <NA>     5   8.5         2
#> 6   6 <NA>     6   4.5         3
#> 7   7 <NA>     7  10.0         1
#> 8   8 <NA>     8  10.0         0
#> 9   9 <NA>     9   8.5         1
#> 10 10 <NA>    10  10.0         0
}
