% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_last_nodes_created.R
\name{select_last_nodes_created}
\alias{select_last_nodes_created}
\title{Select the last set of nodes created in a graph}
\usage{
select_last_nodes_created(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Select the last nodes that were created
in a graph object of class \code{dgr_graph}. This
function should ideally be used just after creating
the nodes to be selected.
}
\examples{
# Create a graph and add 4 nodes
# in 2 separate function calls
graph <-
  create_graph() \%>\%
  add_n_nodes(
    n = 2,
    type = "a",
    label = c("a_1", "a_2")) \%>\%
  add_n_nodes(
    n = 2,
    type = "b",
    label = c("b_1", "b_2"))

# Select the last nodes created (2 nodes
# from the last function call) and then
# set their color to be `red`
graph <-
  graph \%>\%
  select_last_nodes_created() \%>\%
  set_node_attrs_ws(
    node_attr = color,
    value = "red") \%>\%
  clear_selection()

# Display the graph's internal node
# data frame to verify the change
get_node_df(graph)
#>   id type label color
#> 1  1    a   a_1  <NA>
#> 2  2    a   a_2  <NA>
#> 3  3    b   b_1   red
#> 4  4    b   b_2   red
}
