% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_graph_actions.R
\name{reorder_graph_actions}
\alias{reorder_graph_actions}
\title{Trigger the execution of a series of graph actions}
\usage{
reorder_graph_actions(graph, indices)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{indices}{a numeric vector that provides
the new ordering of graph actions. This vector
can be the same length as the number of graph
actions, or, of shorter length. In the latter
case, the ordering places the given items first
and the remaining actions will follow.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Execute the graph actions stored in
the graph through the use of the
\code{add_graph_action()} function. These actions
will be invoked in order and any errors
encountered will trigger a warning message and
result in no change to the input graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 4,
    m = 4,
    set_seed = 23)

# Add three graph actions to the
# graph
graph <-
  graph \%>\%
  add_graph_action(
    fcn = "rescale_node_attrs",
    node_attr_from = "pagerank",
    node_attr_to = "width",
    action_name = "pgrnk_to_width") \%>\%
  add_graph_action(
    fcn = "set_node_attr_w_fcn",
    node_attr_fcn = "get_pagerank",
    column_name = "pagerank",
    action_name = "get_pagerank") \%>\%
  add_graph_action(
    fcn = "colorize_node_attrs",
    node_attr_from = "width",
    node_attr_to = "fillcolor",
    action_name = "pgrnk_fillcolor")

# View the graph actions for the graph
# object by using the function called
# `get_graph_actions()`
graph \%>\%
  get_graph_actions()

# We note that the order isn't
# correct and that the `get_pagerank`
# action should be the 1st action
# and `pgrnk_to_width` should go
# in 2nd place; to fix this, use the
# function `reorder_graph_actions()`
# and specify the reordering with a
# numeric vector
graph <-
  graph \%>\%
  reorder_graph_actions(
    indices = c(2, 1, 3))

# View the graph actions for the graph
# object once again to verify that
# we have the desired order of actions
graph \%>\%
  get_graph_actions()
}
