% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Etronq_IG.R
\name{Etronq_IG}
\alias{Etronq_IG}
\title{Truncated mean of the Inverse Gaussian distribution}
\usage{
Etronq_IG(
  d,
  mean,
  shape = dispersion * mean^2,
  dispersion = shape/mean^2,
  less.than.d = TRUE
)
}
\arguments{
\item{d}{cut-off value.}

\item{mean}{mean (location) parameter \eqn{\mu}{mu}, must be positive.}

\item{shape}{shape parameter \eqn{\beta}{beta}, must be positive.}

\item{dispersion}{alternative parameterization to the shape parameter, dispersion = 1 / rate.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_IG}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{E_IG}}}{ gives the expected value.}
 \item{\code{\link{V_IG}}}{ gives the variance.}
 \item{\code{\link{Etronq_IG}}}{ gives the truncated mean.}
 \item{\code{\link{SL_IG}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_IG}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_IG}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_IG}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_IG}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Truncated mean of the Inverse Gaussian distribution with
 mean \eqn{\mu}{mu} and shape parameter \eqn{\beta}{beta}.
}
\details{
The Pareto distribution with rate parameter \eqn{\lambda}{lam} as well as shape
  parameter \eqn{\alpha}{a} has density: \deqn{f\left(x\right) = \frac{\alpha%
  \lambda^{\alpha}}{(\lambda + x)^{\alpha + 1}}}{f(x) = (a lam^a)/ (lam + x)^(a + 1)}
  for \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\alpha, \lambda > 0}{a, lam > 0}.
}
\examples{

Etronq_IG(d = 2, mean = 2, shape = 5)

}
\seealso{
Other Inverse Gaussian Distribution: 
\code{\link{E_IG}()},
\code{\link{Elim_IG}()},
\code{\link{MGF_IG}()},
\code{\link{Mexcess_IG}()},
\code{\link{SL_IG}()},
\code{\link{TVaR_IG}()},
\code{\link{V_IG}()},
\code{\link{VaR_IG}()}
}
\concept{Inverse Gaussian Distribution}
