% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechetCopula.R
\name{frechet}
\alias{frechet}
\alias{cFrechet}
\alias{crFrechet}
\title{Fréchet Copula}
\usage{
cFrechet(u1, u2, dependencyParameter, ...)

crFrechet(numberSimulations = 10000, seed = 42, dependencyParameter)
}
\arguments{
\item{u1, u2}{points at which to evaluate the copula.}

\item{dependencyParameter}{correlation parameters, must be vector of length 2.}

\item{...}{other parameters.}

\item{numberSimulations}{Number of simulations.}

\item{seed}{Simulation seed, 42 by default.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{cFrechet}}}{ returns the value of the copula.}
    \item{\code{\link{crFrechet}}}{ returns simulated values of the copula.}
  }
}
\description{
Computes CDF and simulations of the Fréchet copula.
}
\details{
The Fréchet copula has CDF :
  \deqn{C(u_{1}, u_{2}) = (1 - \alpha - \beta)(u_{1} \times u_{2}) + \alpha\min(u_{1}, u_{2})%
    + \beta\max(u_{1} + u_{2} - 1, 0)}{C(u1, u2) = (1 - alpha - beta) (u1 * u2) %
    + alpha min(u1, u2) + beta max(u1 + u2 - 1, 0)}
  for \eqn{u_{1}, u_{2}, \alpha, \beta \in [0, 1]}{0 <= u1, u2, alpha, beta <= 1} %
   and \eqn{\alpha + \beta \leq 1}{alpha + beta <= 1}.
}
\examples{
cFrechet(u1 = .76, u2 = 0.4, dependencyParameter = c(0.2, 0.3))

crFrechet(numberSimulations = 10, seed = 42, dependencyParameter = c(0.2, 0.3))

}
