% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiversityOccu.R
\name{batchoccuavg}
\alias{batchoccuavg}
\title{Fits occupancy models for multiple species detection history and calculated model average}
\usage{
batchoccuavg(pres, sitecov, obscov, spp, form, dredge = FALSE, delta = 2)
}
\arguments{
\item{pres}{a data.frame where rows are the sites and columns are a series of
presence-absence observation from multiple species, every species needs to
have the same number of observations.}

\item{sitecov}{a data.frame where every row is a site, and every column is a
measurement of that site, such as elevation or slope, this covariates are
usually more constant.}

\item{obscov}{a list where every element is a data frame with the daily
covariates for each site, that is a measurement for each day, such as average
temperature of a day, this covariates are usually very .}

\item{spp}{the number of species in the pres data.frame}

\item{form}{a formula in the format ~ obscov ~ sitcov, the first arguments
will be used to calculate probability of detection and the second part the
occupancy.}

\item{dredge}{default = FALSE, if TRUE, for each species, the best occupancy
model will be determined by fitting all possible models and ranking by AICc.}

\item{delta}{default = 2, AICc difference used for model averaging}
}
\value{
A list with the average models for each species.
}
\description{
This function takes a data.frame with multiple detection history from
various species in different sites, covariates of each site to calculate
occupancy, variables specific to sampling days to calculate probability of
detection. It features an automatic model selection when dredge = TRUE.
}
\details{
This function fits the single season occupancy model of MacKenzie et al (2002),
for multiple species and it can automatically select the best model for each
specie based on AICc, ther result of this function is the model average.
}
\examples{
\dontrun{
data("IslandBirds")
data("Daily_Cov")
data("siteCov")
BirdOccupancy <-batchoccuavg(pres = IslandBirds, sitecov = siteCov, obscov =
Daily_Cov, spp =  5, form = ~ Day + Wind + Rain + Noise + Clouds ~
Elev + AgroFo + SecVec + Wetland)
#Summary of averaged model for species 2
summary(BirdOccupancy$models[[2]])
}
#Dredge for all species
}
\seealso{
\code{\link[DiversityOccupancy]{diversityoccu}}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
