% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DCPensionVaR.R
\name{DCPensionVaR}
\alias{DCPensionVaR}
\title{Monte Carlo VaR for DC pension}
\usage{
DCPensionVaR(mu, sigma, p, life.expectancy, number.trials, cl)
}
\arguments{
\item{mu}{Expected rate of return on pension-fund assets}

\item{sigma}{Volatility of rate of return of pension-fund assets}

\item{p}{Probability of unemployment in any period}

\item{life.expectancy}{Life expectancy}

\item{number.trials}{Number of trials}

\item{cl}{VaR confidence level}
}
\value{
VaR for DC pension
}
\description{
Generates Monte Carlo VaR for DC pension in Chapter 6.7.
}
\examples{
# Estimates the price of an American Put
   DCPensionVaR(.06, .2, .05, 80, 100, .95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, Kevin. Measuring Market Risk, Wiley, 2007.
}

