% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visW}
\alias{visW}
\title{Plot the estimates for the latent factors}
\usage{
visW(mcmc.output, Y, D, chain = 1, factors = c(1, 2))
}
\arguments{
\item{mcmc.output}{an mcmc list as produced by clean.mcmc}

\item{Y}{the matrix of data}

\item{D}{the number of latent factors}

\item{chain}{the chain to plot (default = 1)}

\item{factors}{a vector indicating the factors to plot (default = c(1, 2))}
}
\value{
res.W a data frame containing the estimates for the factors, and their lower
and upper bounds

Inertia the percentage of total inertia captured by each of the factors
}
\description{
Plot the estimates for the latent factors
}
\examples{
require(DrBats)
data("toydata")
data("stanfit")
codafit <- coda.obj(stanfit)
Y <- toydata$Y.simul$Y
N = nrow(Y)
D = toydata$wlu$D
P = ncol(Y)
## PCA in the histogram basis
obs <- toydata$X
times <- toydata$t
pca.data <- pca.Deville(obs, times, t.range = c(min(times), max(times)), breaks = 15)
## Post-processing landmark information
rotation <- toydata$wlu$Q # rotation matrix
real.W <- toydata$wlu$W # PCA-determined latent factors
real.B <- t(pca.data$Cp[, 1:(toydata$wlu$D)]) # PCA-determined scores
mcmc.output <- clean.mcmc(N, P, D, codafit, rotation, real.W, real.B)
W.res <- visW(mcmc.output, Y, D, chain = 1, factors = c(1, 2))

}
\author{
Gabrielle Weinrott
}

