% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{compute_correlation_matrices}
\alias{compute_correlation_matrices}
\title{Computes correlation matrices for specified network layers}
\usage{
compute_correlation_matrices(layers, settings)
}
\arguments{
\item{layers}{[list] Named list with different network layers containing data and identifiers for both
groups (generated from \code{\link[DrDimont]{make_layer}})}

\item{settings}{[list] A named list containing pipeline settings. The settings list has to be
initialized by \code{\link[DrDimont]{drdimont_settings}}. Items in the named list can be
adjusted as desired.}
}
\value{
A nested named list with first-level elements `correlation_matrices` and `annotations`. The second
level elements are `groupA` and `groupB` (and `both` at `annotations`). These contain a named list of matrix
objects (`correlation_matrices`) and data frames (`annotations`) mapping the graph node IDs to biological
identifiers. The third level elements are the layer names given by the user.
}
\description{
Constructs and returns a correlation/adjacency matrices for each network layer
and each group. The adjacency matrix of correlations is computed using \link[WGCNA]{cor}.
The handling of missing data can be specified. Optionally, the adjacency matrices of the
correlations can be saved. Each node is mapped to the biological identifiers given in the
layers and the mapping table is returned as `annotations`.
}
\examples{
\dontshow{
WGCNA::disableWGCNAThreads()
}

example_settings <- drdimont_settings(
                        handling_missing_data=list(
                            default="all.obs"))

# mini example with reduced mRNA layer for shorter runtime:
data(mrna_data)
reduced_mrna_layer <- make_layer(name="mrna",
                          data_groupA=mrna_data$groupA[1:5,2:6],
                          data_groupB=mrna_data$groupB[1:5,2:6],
                          identifiers_groupA=data.frame(gene_name=mrna_data$groupA$gene_name[1:5]),
                          identifiers_groupB=data.frame(gene_name=mrna_data$groupB$gene_name[1:5]))

example_correlation_matrices <- compute_correlation_matrices(
                                    layers=list(reduced_mrna_layer), 
                                    settings=example_settings)

# to run all layers use layers=layers_example from data(layers_example) 
# in compute_correlation_matrices()

}
