% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_reduction.R
\name{network_reduction_by_pickHardThreshold}
\alias{network_reduction_by_pickHardThreshold}
\title{[INTERNAL] Reduces network based on WGCNA::pickHardThreshold function}
\source{
The original implementation of pickHardThreshold is used from
\code{\link[WGCNA]{pickHardThreshold.fromSimilarity}}
}
\usage{
network_reduction_by_pickHardThreshold(
  adjacency_matrix,
  r_squared_cutoff = 0.85,
  cut_vector = seq(0.2, 0.8, by = 0.01),
  mean_number_edges = NULL,
  edge_density = NULL
)
}
\arguments{
\item{adjacency_matrix}{[matrix] Adjacency matrix of correlations computed using \code{\link[WGCNA]{cor}} in
\code{\link[DrDimont]{compute_correlation_matrices}}}

\item{r_squared_cutoff}{[float] A number indicating the desired minimum scale free topology fitting index R^2 for reduction
using \code{\link[WGCNA]{pickHardThreshold}}. (default: 0.85)}

\item{cut_vector}{[sequence of float] A vector of hard threshold cuts for which the scale free topology fit indices are to
be calculated during reduction with \code{\link[WGCNA]{pickHardThreshold}}. (default: seq(0.2, 0.8, by = 0.01))}

\item{mean_number_edges}{[int] Find a suitable edge weight cutoff employing \code{\link[WGCNA]{pickHardThreshold}} to reduce
the network to at most the specified mean number of edges. Attention: This parameter overwrites the 'r_squared_cutoff' and
'edge_density' parameters if not set to NULL. (default: NULL)}

\item{edge_density}{[float] Find a suitable edge weight cutoff employing \code{\link[WGCNA]{pickHardThreshold}} to reduce the
network to at most the specified edge density. Attention: This parameter overwrites the 'r_squared_cutoff' parameter if not set
to NULL. (default: NULL)}
}
\value{
A reduced adjacency matrix of correlations with NA's inserted at positions below
estimated cutoff.
}
\description{
[INTERNAL] This function uses \code{\link[WGCNA]{pickHardThreshold.fromSimilarity}} to analyze
scale free topology for multiple hard thresholds. A cutoff is estimated, if no cutoff is
found the function terminates with an error message. All values below the cutoff will be set to NA and the
reduced adjacency is returned.
}
\keyword{internal}
