% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynComm.R
\docType{methods}
\name{results}
\alias{results}
\alias{DynComm.results}
\title{results(differential)}
\usage{
DynComm.results(dyncomm,differential)
}
\arguments{
\item{dyncomm}{A DynComm object, if not using the inline version of the 
function call}

\item{differential}{If TRUE, only values that have changed in the latest run 
will be returned}
}
\value{
a two column matrix where, the first column is the name of the 
result and, the second column is its value.
}
\description{
This method returns additional results from the selected post processing
algorithm or the main algorithm. See \code{\link{select}} to know how to 
select an algorithm.
}
\details{
Additional results are any results other than those returned by other 
existing functions like \code{\link{quality}}, \code{\link{time}} and 
\code{\link{communityMapping}}.
Passing the parameter differential set to TRUE, will return only results that
have changed from the previous to last iteration.
}
\examples{
library(DynComm)
Parameters<-matrix(c("e","0.1","w", "FALSE"),ncol=2, byrow=TRUE)
dc<-DynComm(ALGORITHM$LOUVAIN,CRITERION$MODULARITY,Parameters)
dc$addRemoveEdges(
 matrix(
   c(10,20,10,30,20,30,30,60,40,60,40,50,50,70,60,70)
   ,ncol=2,byrow=TRUE)
)
dc$results()

}
\seealso{
\code{\link{DynComm}} , \code{\link{postProcess}}
}
\author{
poltergeist0
}
