\name{ellipsoid}
\alias{ellipsoid}
\title{Ellipsoid function for optimization problems}

\usage{
ellipsoid(x)
}

\arguments{
\item{x}{
  A numeric vector of parameters for which the Ellipsoid function is evaluated.
  }
}

\value{
Returns a numeric value, which is the evaluation of the Ellipsoid function at the input vector \code{x}.
}

\description{
The Ellipsoid function is a standard benchmark function used in optimization. It is convex and has a single global minimum at the origin. The function is a generalization of the quadratic function and is often used to evaluate the performance of optimization algorithms in high-dimensional spaces. Although it can be defined in any number of dimensions, it is commonly evaluated in 4 dimensions in this documentation.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
ellipsoid(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
ellipsoid(x)

# Contour Plot: Visualizing the Ellipsoid Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) ellipsoid(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Ellipsoid Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = ellipsoid, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) ellipsoid(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Ellipsoid Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
{De Jong, K. A. (1975). \emph{An analysis of the behavior of a class of genetic adaptive systems}. Doctoral dissertation, University of Michigan.}
}
