% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wto.R
\name{wto}
\alias{wto}
\title{Weighted Topological Overlap}
\usage{
wto(network, signed = TRUE, diagonal.zero = TRUE)
}
\arguments{
\item{network}{Symmetric matrix or data frame.
A symmetric network}

\item{signed}{Boolean (length = 1).
Whether the signed version should be used.
Defaults to \code{TRUE}.
Use \code{FALSE} for absolute values}

\item{diagonal.zero}{Boolean (length = 1).
Whether diagonal of overlap matrix should be set to zero.
Defaults to \code{TRUE}.
Use \code{FALSE} to allow overlap of a node with itself}
}
\value{
A symmetric matrix of weighted topological overlap
values between each pair of variables
}
\description{
Computes weighted topological overlap following
the Novick et al. (2009) definition
}
\examples{
# Obtain network
network <- network.estimation(wmt2[,7:24], model = "glasso")

# Compute wTO
wto(network)

}
\references{
\strong{Original formalization} \cr
Nowick, K., Gernat, T., Almaas, E., & Stubbs, L. (2009).
Differences in human and chimpanzee gene expression patterns define an evolving network of transcription factors in brain.
\emph{Proceedings of the National Academy of Sciences}, \emph{106}, 22358-22363.
}
