% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/boxConcThree.R
\name{boxConcThree}
\alias{boxConcThree}
\title{Three box plots side-by-side}
\usage{
boxConcThree(eList, tinyPlot = FALSE, printTitle = TRUE,
  moreTitle = "WRTDS", customPar = FALSE, font.main = 2, cex = 0.8,
  cex.main = 1.1, cex.axis = 1.1, ...)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{tinyPlot}{logical variable, if TRUE plot is designed to be plotted small as part of a multi-plot figure, default is FALSE.}

\item{printTitle}{logical variable if TRUE title is printed, if FALSE not printed (this is best for a multi-plot figure)}

\item{moreTitle}{character specifying some additional information to go in figure title, typically some information about the specific estimation method used, default is no additional information}

\item{customPar}{logical defaults to FALSE. If TRUE, par() should be set by user before calling this function}

\item{font.main}{font to be used for plot main titles}

\item{cex}{numerical value giving the amount by which plotting symbols should be magnified}

\item{cex.main}{magnification to be used for main titles relative to the current setting of cex}

\item{cex.axis}{magnification to be used for axis annotation relative to the current setting of cex}

\item{\dots}{arbitrary graphical parameters that will be passed to genericEGRETDotPlot function (see ?par for options)}
}
\description{
This function is used to compare the distribution of concentration in the sample and predicted data set.

Data come from named list, which contains a Sample dataframe with the sample data,
a Daily dataframe with the daily flow data,
and an INFO dataframe with metadata.

Although there are a lot of optional arguments to this function, most are set to a logical default.
}
\examples{
eList <- Choptank_eList
# Water year:
boxConcThree(eList)
# Graphs consisting of Jun-Aug
eList <- setPA(eList, paStart=6,paLong=3)
boxConcThree(eList)
}
\seealso{
\code{\link[graphics]{boxplot}}
}
\keyword{graphics}
\keyword{statistics}
\keyword{water-quality}

