% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stitch.R
\name{stitch}
\alias{stitch}
\title{stitch surfaces}
\usage{
stitch(eList, sample1StartDate, sample1EndDate, sample2StartDate,
  sample2EndDate, surfaceStart = NA, surfaceEnd = NA,
  minNumObs = 100, minNumUncen = 50, fractMin = 0.75, windowY = 7,
  windowQ = 2, windowS = 0.5, edgeAdjust = TRUE, verbose = FALSE,
  run.parallel = FALSE)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{sample1StartDate}{The Date (or character in YYYY-MM-DD) of the first sample to be used in estimating the first segment of the surfaces object.}

\item{sample1EndDate}{The Date (or character in YYYY-MM-DD) of the last sample to be used in the first segment of the surfaces object.}

\item{sample2StartDate}{The Date (or character in YYYY-MM-DD) of the first sample to be used in the second segment of the surfaces object.}

\item{sample2EndDate}{The Date (or character in YYYY-MM-DD) of the last sample to be used in the second segment of the surfaces object.}

\item{surfaceStart}{The Date (or character in YYYY-MM-DD) that is the start of the WRTDS model to be estimated and the first of the 
daily outputs to be generated. Default is NA, which means that the surfaceStart is based on the date of the first sample.}

\item{surfaceEnd}{The Date (or character in YYYY-MM-DD) that is the end of the WRTDS model to be estimated and the last of the daily outputs 
to be generated.  Default is NA, which means that the surfaceEnd is based on the date of the last sample.}

\item{minNumObs}{numeric specifying the miniumum number of observations required to run the weighted regression, default is 100}

\item{minNumUncen}{numeric specifying the minimum number of uncensored observations to run the weighted regression, default is 50}

\item{fractMin}{numeric specifying the minimum fraction of the observations required to run the weighted regression, default is 0.75. The
minimum number will be the maximum of minNumObs and fractMin multiplied by total number of observations.}

\item{windowY}{numeric specifying the half-window width in the time dimension, in units of years, default is 7}

\item{windowQ}{numeric specifying the half-window width in the discharge dimension, units are natural log units, default is 2}

\item{windowS}{numeric specifying the half-window with in the seasonal dimension, in units of years, default is 0.5}

\item{edgeAdjust}{logical specifying whether to use the modified method for calculating the windows at the edge of the record.
The edgeAdjust method tends to reduce curvature near the start and end of record.  Default is TRUE.}

\item{verbose}{logical specifying whether or not to display progress message}

\item{run.parallel}{logical to run bootstrapping in parallel or not}
}
\description{
This function creates a continuous surfaces object that starts just before 
surfaceStart and ends just after surfaceEnd. It is made up from two surfaces 
objects created when there is a wall specified for the analysis.  The first 
surfaces object is based on data prior to the wall and the second surfaces object 
is based on data after the wall.  The wall is located just after sample1EndDate.
The Daily data frame is used only to set the minimum and maximum discharges used 
to construct the indices for discharges in the surfaces.
}
\examples{
eList <- Choptank_eList

surfaceStart <- "1986-10-01"
surfaceEnd <- "2010-09-30"

# Surface skips a few years:
sample1StartDate <- "1986-10-01"
sample1EndDate <- "1992-09-30"
sample2StartDate <- "1996-10-01"
sample2EndDate <- "2011-09-30"

\dontrun{
surface_skip <- stitch(eList, 
                         sample1StartDate, sample1EndDate, 
                         sample2StartDate, sample2EndDate,
                         surfaceStart, surfaceEnd)

# Surface overlaps a few years:
sample1StartDate <- "1986-10-01"
sample1EndDate <- "1996-09-30"
sample2StartDate <- "1992-10-01"
sample2EndDate <- "2011-09-30"

surface_overlap <- stitch(eList, 
                         sample1StartDate, sample1EndDate, 
                         sample2StartDate, sample2EndDate)
}
}
