% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimating_equations.R
\name{ee.glm}
\alias{ee.glm}
\title{Estimating equation for ELCIC under GLM}
\usage{
ee.glm(x, y, beta, dist)
}
\arguments{
\item{x}{A matrix containing covariates. The first column should be all ones corresponding to the intercept. See more details in}

\item{y}{A vector containing outcomes.}

\item{beta}{A plug-in estimator solved by an external estimating procedure.}

\item{dist}{A specified distribution. It can be "gaussian", "poisson",and "binomial".}
}
\value{
A matrix containing values of calculated estimating equations.
}
\description{
A specified estimating equation for ELCIC under GLM. This estimating equation is used for marginal mean selection.
}
\note{
"x" and "y" should be all observed.
}
\examples{
## tests
# load data
data(glmsimdata)
x<-glmsimdata$x
y<-glmsimdata$y
# obtain the estimates. Note that x matrix already contains intercept.
fit<-glm(y~x-1,family="poisson")
beta<-fit$coefficients
ee.matrix<-ee.glm(x, y, beta, dist="poisson")
apply(ee.matrix,1,mean)

}
