% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{IC}
\alias{IC}
\title{Calculate information criteria (DIC, BPIC), effective number of parameters and
constituent posterior deviance (D) summaries (meanD = mean of D, Dmean = D
for mean of posterior parameters and minD = minimum of D).}
\usage{
IC(
  emc,
  stage = "sample",
  filter = 0,
  use_best_fit = TRUE,
  print_summary = TRUE,
  digits = 0,
  subject = NULL,
  group_only = FALSE
)
}
\arguments{
\item{emc}{emc object or list of these}

\item{stage}{A string. Specifies which stage you want to plot.}

\item{filter}{An integer or vector. If it's an integer, iterations up until the value set by \code{filter} will be excluded.
If a vector is supplied, only the iterations in the vector will be considered.}

\item{use_best_fit}{Boolean, default TRUE use best of minD and Dmean in
calculation otherwise always use Dmean}

\item{print_summary}{Boolean (default TRUE) print table of results}

\item{digits}{Integer, significant digits in printed table}

\item{subject}{Integer or string selecting a single subject, default NULL
returns sums over all subjects}

\item{group_only}{Boolean. If \code{TRUE} will calculate the IC for the group-level only}
}
\value{
Table of DIC, BPIC, EffectiveN, meanD, Dmean, and minD
}
\description{
Calculate information criteria (DIC, BPIC), effective number of parameters and
constituent posterior deviance (D) summaries (meanD = mean of D, Dmean = D
for mean of posterior parameters and minD = minimum of D).
}
