% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.q.R
\name{get.q}
\alias{get.q}
\title{Generate a parameter matrix with q.min and q.max values for robust EMMA.}
\usage{
get.q(
  X,
  l = 0,
  q.min = 2,
  q.max = 10,
  criteria.min = 0.5,
  criteria.max = "local_max",
  correct.output = TRUE,
  ...
)
}
\arguments{
\item{X}{\code{Numeric} matrix, input data set with m samples (rows) 
and n variables (columns).}

\item{l}{\code{Numeric} vector, weight transformation limits, default 
is zero.}

\item{q.min}{\code{Numeric} scalar, minimum number of end-members to use, 
default is 2.}

\item{q.max}{\code{Numeric} scalar, maximum number of end-members to use, 
default is 10.}

\item{criteria.min}{\code{Numeric} scalar, minimum value of explained 
variance reached to be a valid model realisation, default is 0.5.}

\item{criteria.max}{\code{Character} or numeric scalar, either keyword 
\code{"local_max"} to use first local maximum or any numeric value of 
explained variance, default is \code{"local_max"}.}

\item{correct.output}{\code{Logical} scalar, option to correct the output 
for twisted values and remove combinations with NA-values. See details.}

\item{...}{Further arguments, passed to the function.}
}
\value{
\code{Numeric} matrix of class \code{"EMMAgeo_q"}, minimum and 
maximum numbers of end-members as well as corresponding weight 
transformation values as rownames.
}
\description{
This function uses the input data matrix \code{X} and a vector of weight
transformation limits to generate a matrix of minimum and maximum likely 
numbers of end-members to be used to model and extract robust end-members.
}
\details{
The parameter \code{q.min} should be at least 2 because otherwise the 
entire dataset would consist of one end-member and there would be no
variability at all. The parameter \code{q.max} is set to 10 by default,
based on practical issues. In natural systems, there are only rarely 
occasions when such a high number of sediment transport regimes may be
preserved in and can be resolved from sedimentary deposits. The parameter
\code{l} should be a vector between the minimum possible (zero) and maximum
possible value (by definition the median, 0.5, but usually a lower value).
Whensubmitting only a scalar, the variability can be only due to the range
of possible endmembers (between \code{q.min} and \code{q.max}). If the 
parameter \code{correct.output} is enabled, this can decrease the number of 
valid values for \code{l}, i.e. the number of rows of the output matrix 
may no longer be the same as the length of the input vector of \code{l}. In 
such a case the vector \code{l} must be replaced by the rownames of the 
output matrix (\code{l <- as.numeric(rownames(get.q()))}).
}
\examples{

## load example data set
data("example_X")

## create parameter matrix
get.q(X = X, l = c(0, 0.05, 0.10, 0.15))

}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180.
}
\seealso{
\code{\link{EMMA}}, \code{\link{test.parameters}}, 
\code{\link{test.robustness}}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
