% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{EQRN_fit}
\alias{EQRN_fit}
\title{EQRN fit function for independent data}
\usage{
EQRN_fit(
  X,
  y,
  intermediate_quantiles,
  interm_lvl,
  shape_fixed = FALSE,
  net_structure = c(5, 3, 3),
  hidden_fct = torch::nnf_sigmoid,
  p_drop = 0,
  intermediate_q_feature = TRUE,
  learning_rate = 1e-04,
  L2_pen = 0,
  shape_penalty = 0,
  scale_features = TRUE,
  n_epochs = 500,
  batch_size = 256,
  X_valid = NULL,
  y_valid = NULL,
  quant_valid = NULL,
  lr_decay = 1,
  patience_decay = n_epochs,
  min_lr = 0,
  patience_stop = n_epochs,
  tol = 1e-06,
  orthogonal_gpd = TRUE,
  patience_lag = 1,
  optim_met = "adam",
  seed = NULL,
  verbose = 2,
  device = default_device()
)
}
\arguments{
\item{X}{Matrix of covariates, for training.}

\item{y}{Response variable vector to model the extreme conditional quantile of, for training.}

\item{intermediate_quantiles}{Vector of intermediate conditional quantiles at level \code{interm_lvl}.}

\item{interm_lvl}{Probability level for the intermediate quantiles \code{intermediate_quantiles}.}

\item{shape_fixed}{Whether the shape estimate depends on the covariates or not (bool).}

\item{net_structure}{Vector of integers whose length determines the number of layers in the neural network
and entries the number of neurons in each corresponding successive layer.
If \code{hidden_fct=="SSNN"}, should instead be a named list with \code{"scale"} and \code{"shape"} vectors for the two respective sub-networks.
Can also be a \code{\link[torch:nn_module]{torch::nn_module}} network with correct input and output dimensions,
which overrides the \code{hidden_fct}, \code{shape_fixed} and \code{p_drop} arguments.}

\item{hidden_fct}{Activation function for the hidden layers. Can be either a callable function (preferably from the \code{torch} library),
or one of the the strings \code{"SNN"}, \code{"SSNN"} for self normalizing networks (with common or separated networks for the scale and shape estimates, respectively).
In the latter cases, \code{shape_fixed} has no effect.}

\item{p_drop}{Probability parameter for dropout before each hidden layer for regularization during training.
\code{alpha-dropout} is used with SNNs.}

\item{intermediate_q_feature}{Whether to use the \code{intermediate_quantiles} as an additional covariate, by appending it to the \code{X} matrix (bool).}

\item{learning_rate}{Initial learning rate for the optimizer during training of the neural network.}

\item{L2_pen}{L2 weight penalty parameter for regularization during training.}

\item{shape_penalty}{Penalty parameter for the shape estimate, to potentially regularize its variation from the fixed prior estimate.}

\item{scale_features}{Whether to rescale each input covariates to zero mean and unit variance before applying the network (recommended).}

\item{n_epochs}{Number of training epochs.}

\item{batch_size}{Batch size used during training.}

\item{X_valid}{Covariates in a validation set, or \code{NULL}.
Used for monitoring validation loss during training, enabling learning-rate decay and early stopping.}

\item{y_valid}{Response variable in a validation set, or \code{NULL}.
Used for monitoring validation loss during training, enabling learning-rate decay and early stopping.}

\item{quant_valid}{Intermediate conditional quantiles at level \code{interm_lvl} in a validation set, or \code{NULL}.
Used for monitoring validation loss during training, enabling learning-rate decay and early stopping.}

\item{lr_decay}{Learning rate decay factor.}

\item{patience_decay}{Number of epochs of non-improving validation loss before a learning-rate decay is performed.}

\item{min_lr}{Minimum learning rate, under which no more decay is performed.}

\item{patience_stop}{Number of epochs of non-improving validation loss before early stopping is performed.}

\item{tol}{Tolerance for stopping training, in case of no significant training loss improvements.}

\item{orthogonal_gpd}{Whether to use the orthogonal reparametrization of the estimated GPD parameters (recommended).}

\item{patience_lag}{The validation loss is considered to be non-improving if it is larger than on any of the previous \code{patience_lag} epochs.}

\item{optim_met}{DEPRECATED. Optimization algorithm to use during training. \code{"adam"} is the default.}

\item{seed}{Integer random seed for reproducibility in network weight initialization.}

\item{verbose}{Amount of information printed during training (0:nothing, 1:most important, 2:everything).}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
An EQRN object of classes \code{c("EQRN_iid", "EQRN")}, containing the fitted network,
as well as all the relevant information for its usage in other functions.
}
\description{
Use the \code{\link[=EQRN_fit_restart]{EQRN_fit_restart()}} wrapper instead, with \code{data_type="iid"}, for better stability using fitting restart.
}
