% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose_model.R
\name{diagnose_model}
\alias{diagnose_model}
\title{Diagnose EcoDiet model}
\usage{
diagnose_model(jags_output, var.to.diag = "all", save = FALSE, save_path = ".")
}
\arguments{
\item{jags_output}{The MCMC output summarized in the class jagsUI object
output by \code{run_model} function}

\item{var.to.diag}{The list of variables for which diagnostic plots should be produced and save. By default, this
argument is "all" hence is run for all the variables.}

\item{save}{Indicates whether diagnostic plots should be produced and saved.}

\item{save_path}{The path indicating where to save the diagnostic plots.}
}
\value{
A matrix containing the Gelman diagnostic for all the variables monitored by the \code{\link{run_model}} function (\code{variables_to_save argument}).
}
\description{
This function operates a diagnostic of the fit EcoDiet model.

A message is printed to provide the number of variables for which the Gelman-Rubin diagnostic exceeds
specific thresholds (> 1.01, > 1.05, >1.1). The list of the 10 worst variables in terms of convergence
is also printed.

You need to have run the \code{run_model} function before using this function.

The design of this function is substantially inspired from a function with a similar objective
in the MixSIAR package [(Stock et al. 2018)](https://doi.org/10.7717/peerj.5096), for which code is available online on
the [MixSIAR GitHub repository](https://github.com/brianstock/MixSIAR).
The diagnostic plots are generated using the \code{ggmcmc} package [(Fernández-i-Marín, 2016)](https://CRAN.R-project.org/package=ggmcmc).
}
\examples{

\donttest{
realistic_biotracer_data <- read.csv(system.file("extdata", "realistic_biotracer_data.csv",
                                               package = "EcoDiet"))
realistic_stomach_data <- read.csv(system.file("extdata", "realistic_stomach_data.csv",
                                             package = "EcoDiet"))

data <- preprocess_data(biotracer_data = realistic_biotracer_data,
                        trophic_discrimination_factor = c(0.8, 3.4),
                        literature_configuration = FALSE,
                        stomach_data = realistic_stomach_data)
                        
write_model(literature_configuration = FALSE)

mcmc_output <- run_model("EcoDiet_model.txt", data, run_param="test")

Gelman_test <- diagnose_model(mcmc_output)
Gelman_test

}

}
\seealso{
\code{\link{run_model}} to run the model
}
