% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/auxiliar.R
\name{aue.sort}
\alias{aue.sort}
\title{Ordering cells in a data frame or matrix}
\usage{
aue.sort(x, ndig)
}
\arguments{
\item{x}{Matrix/data frame to order.}

\item{ndig}{Number of digits coding each allele (e.g. 2: xx, or 3: xxx).}
}
\description{
This program returns a data fame with ordered cells.
For example, in the case of a G data frame of an ecogen object,
the program return a data frame with the cells
of each individual \emph{i} and each loci \emph{j} in ascending order,
i.e., a locus of type 51 is returned as 15.
}
\examples{
\dontrun{

data(eco3)
eco3$G                          # unordered data
eco3$G <- aue.sort(eco3$G, 1)
eco3$G                          # ordered data
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

