% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eco.2spagedi.R
\name{eco.2spagedi}
\alias{eco.2spagedi}
\title{Exporting an ecogen genetic data frame into SPAGeDI format}
\usage{
eco.2spagedi(eco, pop = NULL, ndig, name = "infile.spagedi.txt", smin = 0,
  smax = NULL, int = NULL, nclass = NULL, seqvec = NULL, size = NULL,
  bin = c("sturges", "FD"), distmat = NULL, latlon = FALSE)
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{pop}{The name of the @S slot column with the groups
for the output data. The default option includes all the individuals into
a single group.}

\item{ndig}{Number of digits coding each allele
(e.g., 1: x, 2: xx, or 3: xxx).}

\item{name}{The name of the output file.}

\item{smin}{Minimum class distance in the units of the @XY slot data.}

\item{smax}{Maximum class distance in the units of the @XY slot data.}

\item{int}{Distance interval in the units of the @XY slot data.}

\item{nclass}{Number of classes.}

\item{seqvec}{Vector with breaks in the units of the @XY slot data.}

\item{size}{Number of individuals per class.}

\item{bin}{Rule for constructing intervals when a partition parameter (int,
nclass or size) is not given. Default is Sturge's rule (Sturges, 1926). Other
option is Freedman-Diaconis method (Freedman and Diaconis, 1981).}

\item{distmat}{Distance matrix to include (optional).}

\item{latlon}{Are the coordinates in decimal degrees format? Defalut FALSE. If TRUE,
the coordinates must be in a matrix/data frame with the longitude in the first
column and latitude in the second. The position is projected onto a plane in
meters with the function \code{\link[SoDA]{geoXY}}.}
}
\description{
This function converts the genetic data of an ecogen object
in a SPAGeDI input file.
When distance classes are required, they can be constructed by combining
the parameters "int", "smin", "smax", "nclass", "seqvec" and "size", as
described in the function \code{\link{eco.lagweight}}.
A distance matrix can also be included using the "distmat" parameter.
}
\examples{
\dontrun{

data(eco.test)
eco.2spagedi(eco, "pop", ndig = 1,int=2, smax=6, name="infile.spagedi.txt")
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\references{
Freedman D., and P. Diaconis. 1981. On the histogram as a density estimator:
L 2 theory. Probability theory and related fields, 57: 453-476.

Hardy O. and X Vekemans. 2002. SPAGeDi: a versatile computer program
to analyse spatial genetic structure at the individual or population levels.
Molecular ecology notes, 2: 18-620.

Sturges  H. 1926. The choice of a class interval. Journal of the American
Statistical Association, 21: 65-66.
}

