% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_ecogen_with_pop.R
\name{eco.fill_ecogen_with_df}
\alias{eco.fill_ecogen_with_df}
\title{Importation of data frames to ecogen}
\usage{
eco.fill_ecogen_with_df(
  from,
  pop,
  pop_levels,
  XY = NULL,
  P = NULL,
  E = NULL,
  C = NULL,
  bind_columns = FALSE
)
}
\arguments{
\item{from}{ecogen object}

\item{pop}{Name of the column of the slot S with populations.}

\item{pop_levels}{Vector with the name of the populations for each
row of the input data frames. These populations must correspond to
the levels of the column of the slot S used for the argument pop.}

\item{XY}{Population data for slot XY. Defaul NULL.}

\item{P}{Population data for slot P. Defaul NULL.}

\item{E}{Population data for slot E. Defaul NULL.}

\item{C}{Population data for slot C. Defaul NULL.}

\item{bind_columns}{Bind columns of the generated tables 
with the preexisting in the ecogen slots?
Default FALSE (overwrite the slot).}
}
\description{
This function imports into an ecogen object the  population data
contained in a series of data frames.
These data frames can be used to fill the slots XY, P, E and C.
}
\examples{

\dontrun{


data(eco.test)

# create some population data 
to_ecopop <- ecogen2ecopop(eco, "pop")
XY_pop <- to_ecopop[["XY"]]
P_pop <- to_ecopop[["P"]]
E_pop <- to_ecopop[["E"]]

# Add only XY data to the ecogen object
object_with_pop_data <- eco.fill_ecogen_with_df(eco, "pop", c(1,2,3,4), 
                                         XY = XY_pop)
                                         
# Add all the population data to the ecogen object
object_with_pop_data <- eco.fill_ecogen_with_df(eco, "pop", c(1,2,3,4), 
                                         XY = XY_pop, P = P_pop, E = E_pop)

}

}
\seealso{
eco.fill_ecogen_with_ecopop
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
