% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/reproduce_model.R
\name{reproduce_model}
\alias{reproduce_model}
\title{Reproduce a result}
\usage{
reproduce_model(model)
}
\arguments{
\item{model}{the model object containing the result to be reproduced.}
}
\description{
Helps reproduce the result of a simulation by restoring the RNG to the state of a supplied null model object.
}
\details{
Works by resetting the RNG state to what it was for a given EcoSimR simulation.  This only works if the user saved the seed with the saveSeed parameter.
}
\examples{
\dontrun{
finchMod <- cooc_null_model(dataWiFinches, algo="sim1",saveSeed=T)
## Check model output
mean(finchMod$Sim)

reproduce_model(finchMod)

finchMod <- cooc_null_model(dataWiFinches, algo="sim1")
## Check model output is the same as before
mean(finchMod$Sim)
reproduce_model(finchMod)
}
}

