% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{sim2}
\alias{sim2}
\title{Sim2 Co-occurrence Randomization Algorithm}
\usage{
sim2(speciesData)
}
\arguments{
\item{speciesData}{binary presence-absence matrix
(rows = species, columns = sites).}
}
\value{
Returns a binary presence-absence matrix with the same
dimensions and rowsums as the input matrix.
}
\description{
Randomizes a binary matrix speciesData by reshuffling elements
within each row equiprobably.
}
\details{
This algorithm assumes sites are equiprobable, but preserves
differences among species (= row sums).
}
\note{
This algorithm preserves differences in the commonness and rarity of
species (= rowsums), but assumes that all sites are equiprobable. It would
not be appropriate for islands that vary greatly in area, but it would be
appropriate for quadrat censuses in a relatively homogeneous environment.
sim2 can sometimes generate matrices with empty columns, but this is
unlikely unless the matrix is very sparse. sim2 has good Type I error
frequenceis when tested against random matrices. However, if sites do vary
in their suitability or habitat quality, it will often identify aggregated
patterns of species co-occurrence. sim2 and sim9 have the best overall
performance for species co-occurrence analyses. However, because they differ
in their assumptions about site quality, they often differ in their results,
with sim9 often detecting random or segregated patterns for matrices in
which sim2 detects aggregated patterns.
}
\examples{
randomMatrix <- sim2(speciesData=matrix(rbinom(40,1,0.5),nrow=8))
}
\references{
Gotelli, N.J. 2000. Null model analysis of species co-occurrence
patterns. ecology 81: 2606-2621.
}
\seealso{
\code{\link{sim9}} co-occurrence algorithm.
}

