% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmd_test.R
\name{mmd_test}
\alias{mmd_test}
\title{Perform the Maximum Mean Discrepancy unbiased bootstrap test}
\usage{
mmd_test(
  x,
  y,
  kernel = "rbfdot",
  type = ifelse(min(nrow(x), nrow(y)) < 1000, "unbiased", "linear"),
  null = c("permutation", "exact"),
  iterations = 10^3,
  frac = 1,
  ...
)
}
\arguments{
\item{x}{d-dimensional samples from the first distribution}

\item{y}{d-dimensional samples from the first distribution}

\item{kernel}{A character that must match a known kernel. See details.}

\item{type}{Which statistic to use. One of 'unbiased' or 'linear'. See
Gretton et al for details. Default to 'unbiased' if the two vectors are of
length less than \code{1000} and to 'linear' otherwise.}

\item{null}{How to asses the null distribution. This can only be set to exact
if the \code{type} is 'unbiased' and the \code{kernel} is 'rbf'.}

\item{iterations}{How many iterations to do to simulate the null distribution.
Default to 10^4. Only used if \code{null} is 'permutations'}

\item{frac}{For the linear statistic, how many points to sample. See details.}

\item{...}{Further arguments passed to kernel functions}
}
\value{
A list containing the following components:
\itemize{
\item \emph{statistic} the value of the test statistic.
\item \emph{p.value} the p-value of the test.
}
}
\description{
Maximum Mean Discrepancy Unbiased Test
}
\details{
This computes the MMD^2u unbiased statistic or the MMDl linear statistic
from Gretton et al. The code relies on the pairwise_kernel function from the
python module sklearn. To list the available kernels, see the examples.
}
\examples{
x <- matrix(rnorm(1000, 0, 1), ncol = 10)
y <- matrix(rnorm(1000, 0, 2), ncol = 10)
mmd_test(x, y)
mmd_test(x, y, type = "linear")
x <- matrix(rnorm(1000, 0, 1), ncol = 10)
y <- matrix(rnorm(1000, 0, 1), ncol = 10)
 # Set iterations to small number for runtime
 # Increase for more accurate results
mmd_test(x, y, iterations = 10^2)
}
\references{
Gretton, A., Borgwardt, K., Rasch, M. J., Schölkopf, B., & Smola, A. (2012).
\emph{A Kernel Two-Sample Test} Journal of Machine Learning Research (2012)
}
