% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showCodebook.R
\name{showCodebook}
\alias{showCodebook}
\title{Summary Codebook}
\usage{
showCodebook(data, fileFormat = NULL, labelLevels = FALSE,
  includeRecodes = FALSE)
}
\arguments{
\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or
an \code{edsurvey.data.frame.list}}

\item{fileFormat}{a character string indicating the data source to search for variables.
The default \code{NULL} argument searches all available codebooks in the database connection object.}

\item{labelLevels}{a logical value; set to \code{TRUE} to return a snapshot of the label levels in
an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}. When set to \code{FALSE}
(the default), label levels are removed.}

\item{includeRecodes}{a logical value; set to \code{TRUE} to return value labels that have been recoded in
an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}. When set to \code{FALSE}
(the default), only the original value labels are included in the returned \code{data.frame}.}
}
\value{
A \ifelse{latex}{\code{data.frame}}{\code{\link[base]{data.frame}}} that shows the variable names, variable labels, value labels,
                       value levels (if applicable), and the file format data source from an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame},
                       or an \code{edsurvey.data.frame.list}.
}
\description{
Retrieves variable names, variable labels, and value labels for an \code{edsurvey.data.frame}, \code{light.edsurvey.data.frame},
or \code{edsurvey.data.frame.list}
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))

# return codebook information for all codebooks in an edsurvey.data.frame; commonly use View()
\dontrun{
View(showCodebook(sdf))
}

# search both the student and school files, returning levels for variable values
showCodebook(sdf, c("student","school"), labelLevels = TRUE, includeRecodes = FALSE)

# return codebook information for the student file, excluding variable value levels,
# including recoded variables
sdf <- recode.sdf(sdf, recode = list(dsex = list(from = c("Male"), to = c("MALE"))))
showCodebook(sdf, c("student"), labelLevels = FALSE, includeRecodes = TRUE)

# return codebook information for the student file, including variable value levels
# and recoded variables
showCodebook(sdf, c("student","school"), labelLevels = FALSE, includeRecodes = TRUE)
}
\author{
Michael Lee
}
