% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary2.R
\name{summary2}
\alias{summary2}
\title{Summarize edsurvey.data.frame Variables}
\usage{
summary2(data, variable, weightVar = attr(getAttributes(data, "weights"),
  "default"), omittedLevels = FALSE)
}
\arguments{
\item{data}{an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}}

\item{variable}{character variable name}

\item{weightVar}{character weight variable name. Default to be the default weight of \code{data} if exists.
If the given survey data does not have a default weight, the function will produce unweighted statistics instead. 
Can be set to \code{NULL} to return unweighted statistics.}

\item{omittedLevels}{a logical value. When set to \code{TRUE}, drops those levels of the specified \code{variable}.
Use print on an \code{edsurvey.data.frame} to see the omitted levels. Defaults to \code{FALSE}.}
}
\value{
summary of weighted or unweighted statistics of a given variable in an \code{edsurvey.data.frame}  

For categorical variables, summary results include:
\describe{
  \item{N}{number of cases for each category. Weighted N is also produced if users choose to produce weighted statistics.}
  \item{Percent}{percentage of each category. Weighted Percent is also produced if users choose to produce weighted statistics.}
  \item{SE}{standard error of the percentage statistics}
 }
 
For continuous variables, summary results include:
\describe{
  \item{N}{total number of cases (both valid and invalid cases)}
  \item{Min.}{smallest value of the variable}
  \item{1st Qu.}{first quantile of the variable}
  \item{Median}{median value of the variable}
  \item{Mean}{mean of the variable}
  \item{3rd Qu.}{third quantile of the variable}
  \item{Max.}{largest value of the variable}
  \item{SD}{standard deviation or weighted standard deviation}
  \item{NA's}{number of NA's in variable and in weight variables}
  \item{Zero-weight's}{number of zero-weight cases if users choose to produce weighted statistics}
}

If the weight option is chosen, the function produces weighted percentile and standard deviation. Refer to the vignette titled 
\href{https://www.air.org/sites/default/files/EdSurvey-Statistics.pdf}{Statistics} and
the vignette titled
\href{https://www.air.org/sites/default/files/EdSurvey-Percentiles.pdf}{Percentile}
for how the function calculates these statistics (with and without plausible values).
}
\description{
Summarizes edsurvey.data.frame variables.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# print out summary of weighted statistics of a continuous variable
summary2(sdf, "composite")

\dontrun{
# print out summary of weighted statistics of a variable including omitted levels
summary2(sdf, "b017451", omittedLevels = FALSE)

# print out summary of unweighted statistics of a variable
summary2(sdf, "composite", weightVar = NULL)
}
}
\seealso{
\code{\link{percentile}}
}
\author{
Trang Nguyen
}
