% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showPlausibleValues.R
\name{getPlausibleValue}
\alias{getPlausibleValue}
\title{Get Plausible Value Variables}
\usage{
getPlausibleValue(var, data)
}
\arguments{
\item{var}{a character vector naming the subject scale or subscale}

\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or
an \code{edsurvey.data.frame.list}}
}
\value{
a character vector of the set of variable names for the plausible values
}
\description{
Gets the set of variables on an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or
             an \code{edsurvey.data.frame.list} associated with the given subject or subscale.
}
\details{
This function will return a set of plausible value names for variables that
\code{\link{hasPlausibleValue}} returns as true.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))

getPlausibleValue(var="composite", data=sdf)
}
\seealso{
\code{\link{showPlausibleValues}}, \code{\link{updatePlausibleValue}}
}
\author{
Michael Lee and Paul Bailey
}
