% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EllDistrSimCond.R
\name{EllDistrSimCond}
\alias{EllDistrSimCond}
\title{Simulation of elliptically symmetric random vectors
conditionally to some observed part.}
\usage{
EllDistrSimCond(
  n,
  xobs,
  d,
  Sigma = diag(d),
  mu = 0,
  density_R2_,
  genR = list(method = "pinv")
)
}
\arguments{
\item{n}{number of observations to be simulated
from the conditional distribution.}

\item{xobs}{observed value of X that we condition on.
\code{NA} represent unknown components of the vectors to be simulated.}

\item{d}{dimension of the random vector}

\item{Sigma}{(unconditional) covariance matrix}

\item{mu}{(unconditional) mean}

\item{density_R2_}{(unconditional) density of the squared radius.}

\item{genR}{additional arguments for the generation of the squared radius.
It must be a list with a component method: \itemize{
\item If \code{genR$method == "pinv"}, the radius is generated
using the function \code{\link[Runuran:pinv.new]{Runuran::pinv.new()}}.
\item If \code{genR$method == "MH"},
the generation is done using the Metropolis-Hasting algorithm,
with a N(0,1) move at each step.
}}
}
\value{
a matrix of size (n,d) of simulated observations.
}
\description{
Simulation of elliptically symmetric random vectors
conditionally to some observed part.
}
\examples{
d = 3
Sigma = rbind(c(1, 0.8, 0.9),
              c(0.8, 1, 0.7),
              c(0.9, 0.7, 1))
mu = c(0, 0, 0)
result = EllDistrSimCond(n = 100, xobs = c(NA, 2, NA), d = d,
  Sigma = Sigma, mu = mu, density_R2_ = function(x){stats::dchisq(x=x,df=3)})
plot(result)

result2 = EllDistrSimCond(n = 1000, xobs = c(1.3, 2, NA), d = d,
  Sigma = Sigma, mu = mu, density_R2_ = function(x){stats::dchisq(x=x,df=3)})
hist(result2)


}
\references{
Cambanis, S., Huang, S., & Simons, G. (1981).
On the Theory of Elliptically Contoured Distributions,
Journal of Multivariate Analysis.
(Corollary 5, p.376)
}
\seealso{
\code{\link{EllDistrSim}} for the (unconditional) simulation of
elliptically distributed random vectors.
}
