% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{PlotEmbed}
\alias{PlotEmbed}
\title{Helper function for plotting the embedding}
\usage{
PlotEmbed(embed, value = 0, red = 0, green = 0, blue = 0,
  fr = PlotId, fg = PlotId, fb = PlotId, fv = PlotId, powr = 0,
  powg = 0, powb = 0, powv = 0, clust = NULL, nbin = 256,
  maxDens = NULL, fdens = sqrt, limit = 0.01, alpha = NULL, fsom,
  data, col, cluster.colors = ClusterPalette,
  expression.colors = ExpressionPalette,
  na.color = grDevices::rgb(0.75, 0.75, 0.75, if (is.null(alpha)) 0.5
  else alpha/2), plotf = PlotDefault, ...)
}
\arguments{
\item{embed}{The embedding from EmbedSOM}

\item{value}{The column of data to use for plotting the value}

\item{red, green, blue}{The same for RGB components}

\item{fv, fr, fg, fb}{Functions to transform the values before they are normalized}

\item{powv, powr, powg, powb}{Adjustments of the value plotting}

\item{clust}{Cluster labels (used as factor)}

\item{nbin, maxDens, fdens}{Parameters of density calculation, see PlotData}

\item{limit}{Low/high offset for NormalizeColor}

\item{alpha}{Default alpha value}

\item{fsom}{FlowSOM object}

\item{data}{Data matrix, taken from fsom parameter by default}

\item{col}{Different coloring, if supplied}

\item{cluster.colors}{Function to generate cluster colors, default ClusterPalette}

\item{expression.colors}{Function to generate expression color scale, default ExpressionPalette}

\item{na.color}{Color to assign to NA values}

\item{plotf}{Plot function, defaults to slightly decorated 'graphics::plot'}

\item{...}{Extra params passed to the plot function}
}
\description{
Takes the 'embed' object which is the output of EmbedSOM, together with a
multitude of arguments that override how the plotting is done.
}
\examples{
EmbedSOM::PlotEmbed(cbind(rnorm(1e5),rnorm(1e5)))
}
