% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALGO__GWO.R
\name{config_gwo}
\alias{config_gwo}
\title{Configuration object for the Grey Wolf Optimizer Algorithm}
\usage{
config_gwo(
  iterations,
  population_size,
  iterations_same_cost = NULL,
  absolute_tol = NULL
)
}
\arguments{
\item{iterations}{maximum number of iterations.}

\item{population_size}{number of wolves.}

\item{iterations_same_cost}{maximum number of consecutive iterations with the \emph{same}
(see the parameter \code{absolute_tol}) best cost before ending the minimization. If \code{NULL} the
minimization continues for the number of iterations specified by the parameter \code{iterations}.
Default is \code{NULL}.}

\item{absolute_tol}{absolute tolerance when comparing best costs from consecutive iterations.
If \code{NULL} the machine epsilon is used. Default is \code{NULL}.}
}
\value{
\code{config_gwo} returns an object of class \code{GWOConfig}.
}
\description{
Create a configuration object for the Grey Wolf Optimizer Algorithm (GWO). At minimum the number of iterations
(parameter \code{iterations}) and the number of wolves (parameter \code{population_size}) have
to be provided.
}
\references{
\insertRef{Mirjalili2014}{EmiR}
}
