% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridinfo.R
\name{gridInfo}
\alias{gridInfo}
\title{Read grid information from a NetCDF file}
\usage{
gridInfo(file = file.choose(), z = F, verbose = T)
}
\arguments{
\item{file}{file name/path to a wrfinput of wrfchemi file}

\item{z}{TRUE for read wrfinput vertical coordinades}

\item{verbose}{display additional information}
}
\description{
Return a list containing information of a regular grid / domain
}
\note{
just WRF-Chem is suported by now
}
\examples{
grid_d1 <- gridInfo(paste(system.file("extdata", package = "EmissV"),"/wrfinput_d01",sep=""))
\donttest{
grid_d2 <- gridInfo(paste(system.file("extdata", package = "EmissV"),"/wrfinput_d02",sep=""))
grid_d3 <- gridInfo(paste(system.file("extdata", package = "EmissV"),"/wrfinput_d03",sep=""))
names(grid_d1)
# for plot the shapes
library(sp)
shape   <- raster::shapefile(paste0(system.file("extdata", package = "EmissV"),"/BR.shp"))
plot(shape,xlim = c(-55,-40),ylim = c(-30,-15), main="3 nested domains")
axis(1); axis(2); box(); grid()
lines(grid_d1$Box, col = "red")
text(grid_d1$xlim[2],grid_d1$Ylim[1],"d1",pos=4, offset = 0.5)
lines(grid_d2$Box, col = "red")
text(grid_d2$xlim[2],grid_d2$Ylim[1],"d2",pos=4, offset = 0.5)
lines(grid_d3$Box, col = "red")
text(grid_d3$xlim[1],grid_d3$Ylim[2],"d3",pos=2, offset = 0.0)
}
}
