% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{cohortMethod}
\alias{cohortMethod}
\title{Relative risks from a new-user cohort design}
\format{
A data frame with 31 rows and 4 variables: \describe{ \item{drugName}{Name of the drug}
\item{groundTruth}{Whether the drug is a positive (1) or negative (0) control} \item{logRr}{The log
of the incidence rate ratio} \item{seLogRr}{The standard error of the log of the incidence rate
ratio} }
}
\usage{
data(cohortMethod)
}
\description{
Relative risks from a new-user cohort design
}
\details{
A dataset containing the relative risks (and standard errors) produced using a new-user cohort
design. The outcome is acute liver injury, the drug of interest (groundTruth = 1) is Isoniazid Also
included are 30 negative control drugs, for which we believe there to be no causal relation with
acute liver injury. We used the Thomson MarketScan Medicare Supplemental Beneficiaries database,
which contains data on 4.6 million subjects. We selected two groups (cohorts): (1) all subjects
exposed to isoniazid and (2) all subjects having the ailment for which isoniazid is indicated, in
this case tuberculosis, and having received at least one drug that is not known to cause acute
liver injury. We removed all subjects who belonged to both groups and subjects for which less than
180 days of observation time was available prior to their first exposure to the drug in question.
Acute liver injury was identified on the basis of the occurrence of ICD-9-based diagnosis codes
from inpatient and outpatient medical claims and was defined broadly on the basis of codes
associated with hepatic dysfunction, as have been used in prior observational database studies. The
time at risk was defined as the length of exposure + 30 days, and we determined whether subjects
experienced an acute liver injury during their time at risk. Using propensity score stratification,
the cohorts were divided over 20 strata, and an odds ratio over all strata was computed using a
Mantel-Haenszel test. The propensity score was estimated using Bayesian logistic regression using
all available drug, condition, and procedure covariates occurring in the 180 days prior to first
exposure, in addition to age, sex, calendar year of first exposure, Charlson index, number of
drugs, number of visit days, and number of procedures. For more information on this set see
Schuemie et al (2014).
}
\references{
Schuemie MJ, Ryan PB, Dumouchel W, Suchard MA, Madigan D. Interpreting observational studies: why
empirical calibration is needed to correct p-values. Statistics in Medicine 33(2):209-18,2014
}
\keyword{datasets}
