% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expoure_estimate_simple.R
\name{expoure_estimate_simple}
\alias{expoure_estimate_simple}
\title{Assess the environmental exposure using the simplest method: nearest monitoring site method}
\usage{
expoure_estimate_simple(
  individual_data,
  individual_id,
  refrence_id,
  exposure_date,
  pollutant_data,
  pollutant_site = "site",
  pollutant_date = "date",
  pollutant_name = c("pm10", "so2"),
  estimate_interval
)
}
\arguments{
\item{individual_data}{data.frame, inludes the refrence id, individual_id and exposure_date}

\item{individual_id}{character, variable name in the individual_data, which represents the unique id for each individual}

\item{refrence_id}{character, varibale name in the individual_data, which represents the nearest surveillance site for each individual}

\item{exposure_date}{character, varibale name in the individual_data, which represents the start date to estimate the environment exposure}

\item{pollutant_data}{data.frame, contains the pollutant and site informatin. One column represents the site information and other columns represent the concentration of pollutants}

\item{pollutant_site}{character, varibale name in the pollutant_data, which represents the monitoring site information}

\item{pollutant_date}{character, varibale name in the pollutant_data, which represents the surveillance date for pollutant concentration}

\item{pollutant_name}{vector, varibale names in the pollutant_data, which represent the name of the target pollutants to be estimated}

\item{estimate_interval}{continue numeric vector, the estimation period, for example: 0:30, for each individual we estimate the environment exposure ranging from the exposure_date to exposure_date + 30 days}
}
\value{
A list. For each element in the list, there is a dataframe with the first column representing the individual id, the remaining columns represent the exposure estimation
in different time points.
}
\description{
Using the nearest surveillance site as the refrence site to estimate the pollutant exposure.
}
\examples{
 library(EnvExpInd)
 individual_data$date <- as.Date(individual_data$date)
 pollutant_data$date <- as.Date(pollutant_data$date)
 pollutant_data_full <- timeseries_imput(data= pollutant_data,
     date_var = "date",site_var = "site.name",imput_col = 3:8)
 pollutant_data_tem <- merge(pollutant_data_full,site_data,by.x = "site.name",by.y = "site")
 individual_data$refrence_id <- get_refrence_id_simple(
   individual_data = individual_data,
   individual_lat = "lat",
   individual_lon = "lon",
   individual_id = "id",
   site_data = site_data,
   site_lon = "lon",
   site_lat = "lat",
   site_id = "site")
expoure_estimate_simple(
   individual_data = individual_data,
   individual_id = "id",
   refrence_id = "refrence_id",
   exposure_date = "date",
   pollutant_data = pollutant_data_tem,
   pollutant_site = "site.name",
   pollutant_date = "date",
   pollutant_name = c("PM10","PM2.5"),
   estimate_interval = c(0:10))
}
\author{
Bing Zhang, \url{https://github.com/Spatial-R/EnvExpInd}
}
