% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adls_braid_rows.R
\name{braid_rows}
\alias{braid_rows}
\title{Bind lists of list of multiple data frames by row}
\usage{
braid_rows(list)
}
\arguments{
\item{list}{A list of lists of \code{data.frame}s where matching innermost
elements must be bound together row-wise.}
}
\value{
A list of \code{data.frame}s with the combined information from the inputted list.
}
\description{
Row binds the matching innermost data frames in a list of lists. This is
essentially a list inversion \code{\link[purrr:list_transpose]{purrr::list_transpose()}} with row-binding
\code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}
}
\examples{
# A simple example
lst <- lapply(1:5, function(x) {
  list(
    "A" = data.frame("first" = x, "second" = rnorm(x)),
    "B" = data.frame("info" = 1, "other" = 3)
  )
})
braid_rows(lst)

# An example with an additional layer and jagged innermost info
lapply(c(28, 186, 35), function(len) {
  lapply(c("a", "b"), function(x) {
    res <- list(
      "descriptive" = data.frame(
         risk = len,
         event = x,
         var = 1,
         other = 2
       ),
      "results" = data.frame(
         risk = len,
         event = x,
         important = 4:7,
         new = 3:6
      )
    )
    if (len < 30) {
      res <- c(res, list("additional" = data.frame(helps = "extra data")))
    }
    return(res)
  }) |> braid_rows()
}) |> braid_rows()


}
