% Generated by roxygen2 (4.0.2): do not edit by hand
\name{netsim_parallel}
\alias{netsim_parallel}
\title{Stochastic Network Models in Parallel}
\usage{
netsim_parallel(x, param, init, control, merge = TRUE)
}
\arguments{
\item{x}{fitted network model object, as an object of class
\code{\link{netest}}.}

\item{param}{model parameters, as an object of class \code{\link{param.net}}.}

\item{init}{initial conditions, as an object of class \code{\link{init.net}}.}

\item{control}{control settings, as an object of class
       \code{\link{control.net}}.}

\item{merge}{if \code{TRUE}, merge parallel simulations into one \code{netsim}
       object after simulation.}
}
\description{
Simulates stochastic network epidemic models for infectious
             disease in parallel.
}
\details{
This is an experimental implementation of the \code{\link{netsim}} function
that runs model simulations in parallel, using the \code{doParallel} and
\code{doMPI} libraries.

To run models in parallel on a single node, add an argument to the control
settings called \code{ncores} that is equal to the number of parallel cores
the simulations should be initiated on. Use \code{\link{detectCores}} to find
the maximum on a node. Also available is an MPI option, called by adding a
control argument \code{par.type} set to \code{"mpi"}. This requires a local
MPI installation on the computing cluster, and the run of a bash script with
an mpirun call containing the R script with the \code{netsim_parallel} call.

This has been tested on Linux, Mac, and Windows but no guarantees are made
that it will work on every platform. It is best-suited to be run in batch
mode.

Note that this function may be folded into \code{\link{netsim}} and deprecated
in the future.
}
\examples{
\dontrun{
nw <- network.initialize(n = 1000, directed = FALSE)
formation <- ~ edges
target.stats <- 500
dissolution <- ~ offset(edges)
duration <- 50
coef.diss <- dissolution_coefs(dissolution, duration)

est <- netest(nw,
              formation,
              dissolution,
              target.stats,
              coef.diss,
              verbose = FALSE)

param <- param.net(inf.prob = 0.25)
init <- init.net(i.num = 50)

# Runs multicore-type parallelization on single node
control <- control.net(type = "SI", nsteps = 100, verbose = FALSE,
                       par.type = "single", nsims = 4, ncores = 4)

# Note: one should do this function call in batch mode
sims <- netsim_parallel(est, param, init, control)

# Runs parallelization across nodes using MPI
control <- control.net(type = "SI", nsteps = 100, verbose = FALSE,
                       par.type = "mpi", nsims = 4, ncores = 4)

# This would be included in the script file called by mpirun
sims <- netsim_parallel(est, param, init, control)

}
}
\keyword{model}

