% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epinow-internal.R
\name{estimates_by_report_date}
\alias{estimates_by_report_date}
\title{Estimate Cases by Report Date}
\usage{
estimates_by_report_date(
  estimates,
  forecast,
  delays,
  CrIs = c(0.2, 0.5, 0.9),
  target_folder = NULL,
  samples = TRUE
)
}
\arguments{
\item{estimates}{List of data frames as output by \code{estimate_infections}}

\item{forecast}{A list of data frames as output by \code{forecast_infections}}

\item{delays}{A list of delays (i.e incubation period/reporting delay) between infection and report.
Each list entry must also be a list containing the mean, standard deviation of the mean (mean_sd),
standard deviation (sd), standard deviation of the standard deviation and the maximum allowed value for the
that delay (assuming a lognormal distribution with all parameters excepting the max allowed value
on the log scale). To use no delays set this to \code{list()}.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}

\item{target_folder}{Character string specifying where to save results (will create if not present).}

\item{samples}{Logical, defaults to TRUE. Should samples be saved}
}
\value{
A list of samples and summarised estimates of estimated cases by date of report
}
\description{
Estimate Cases by Report Date
}
