% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_object.R
\name{create_object}
\alias{create_object}
\title{Create an `EViews` object on a workfile from R}
\usage{
create_object(wf="",page="",action="",action_opt="",object_name="",
view_or_proc="",options_list="",arg_list="")
}
\arguments{
\item{wf}{Object or a character string representing the name of an `EViews` workfile.}

\item{page}{Object or a character string representing the name of an `EViews` workfile page.}

\item{action}{Any valid `EViews` command for `EViews` object declaration, like \code{freeze}, \code{do}, \code{equation}, \code{table}.}

\item{action_opt}{An option that modifies the default behaviour of the `EViews` action.}

\item{object_name}{The name of the `EViews` object to be acted upon.}

\item{view_or_proc}{The `EViews` object view or procedure to be performed.}

\item{options_list}{An option that modifies the default behaviour of the `EViews` view or procedure.}

\item{arg_list}{A list of `EViews` view or procedure arguments.}
}
\value{
An EViews workfile
}
\description{
Use this function to create an `EViews` object on a workfile from R
}
\examples{
library(EviewsR)
\dontrun{
eviews_wfcreate(wf="EviewsR_workfile",page="EviewsR_page",frequency = "m",start_date = "1990",
end_date = "2022")

exec_commands(c("open EviewsR_workfile","genr y=rnd","genr x=rnd","save","exit"))

create_object(wf="EviewsR_workfile",action="equation",action_opt="",
object_name="eviews_equation",view_or_proc="ls",options_list="",arg_list="y ar(1)")
}
}
\seealso{
eng_eviews, exec_commands, eviews_graph, eviews_import, create_object, eviews_pagesave, rwalk, eviews_wfcreate, eviews_wfsave, export, import_table, import
}
\keyword{documentation}
