% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepapre_descriptive_table.R
\name{prepare_descriptive_table}
\alias{prepare_descriptive_table}
\title{Prepares a Table of Descriptive Statistics}
\usage{
prepare_descriptive_table(df, digits = c(0, 3, 3, 3, 3, 3, 3, 3),
  format = "html")
}
\arguments{
\item{df}{Data frame containing at least one variable that is either numeric
or logical and at least two observations.}

\item{digits}{Number of decimal digits that you want to be displayed for each
column. If you provide NA, then the column is omitted from the output.}

\item{format}{character scalar that is handed over to \code{\link[knitr]{kable}}
(e.g., "html" or "latex").}
}
\value{
A list containing two items.
\describe{
 \item{"df"}{A data frame containing the descriptive table}
 \item{"kable_ret"}{The return value provided by \code{\link[knitr]{kable}} containing the formatted table}
}
}
\description{
Reads a data frame and reports descriptive statistics
(n, mean, standard deviation, minimum, first quartile, median,
third quartile, maximum) for all members of the data frame that are either
numeric or logical.
}
\details{
The \code{digits} parameter from \code{prepare_descriptive_table()} uses the default method of
  \code{\link[knitr]{kable}} to format numbers, calling \code{\link{round}}. This implies that trailing zeroes are
  just omitted.
}
\examples{
t <- prepare_descriptive_table(mtcars)
t$df
}
