% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mlp_net.R
\name{mlp_net-combining-two-networks}
\alias{mlp_merge}
\alias{mlp_net-combining-two-networks}
\alias{mlp_stack}
\title{Combining two networks into one}
\usage{
mlp_merge(net1, net2, same_inputs = FALSE)

mlp_stack(net1, net2)
}
\arguments{
\item{net1}{an object of \code{mlp_net} class}

\item{net2}{an object of \code{mlp_net} class}

\item{same_inputs}{logical, if TRUE both merged networks are assumed to take
         the same inputs (they share the input layer), default is FALSE}
}
\value{
Both functions return an object of \code{mlp_net} class.
}
\description{
These functions construct new network by merging two networks
(they must have the same number of layers) or by connecting
one network outputs to another network inputs (the numbers of output
and input neurons must agree). These functions may be used in constructing
deep learning networks or constructing networks with some special topologies.
}
\examples{
# create two 2-2-2 networks with random weights and plot them
net1 <- mlp_net(c(2, 2, 2))
net1 <- mlp_rnd_weights(net1)
mlp_plot(net1, TRUE)
net2 <- mlp_net(c(2, 2, 2))
net2 <- mlp_rnd_weights(net2)
mlp_plot(net2, TRUE)
# create a 4-3-2 network with random weights and plot it
net3 <- mlp_net(c(4, 3, 2))
net3 <- mlp_rnd_weights(net3)
mlp_plot(net3, TRUE)
# construct new network using net1, net2, and net3 and plot it
net4 <- mlp_stack(mlp_merge(net1, net2), net3)
mlp_plot(net4, TRUE)
}

