% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funs.R
\name{plot.FDX}
\alias{plot.FDX}
\title{Plot Method for \code{FDX} objects}
\usage{
\method{plot}{FDX}(
  x,
  col = c(2, 4, 1),
  pch = c(20, 20, 17),
  lwd = rep(par()$lwd, 3),
  cex = rep(par()$cex, 3),
  type.crit = "b",
  legend = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class "\code{FDX}".}

\item{col}{numeric or character vector of length 3 indicating the
colors of the \enumerate{
\item rejected $p$-values
\item non-rejected $p$-values
\item critical values (if present).
}}

\item{pch}{numeric or character vector of length 3 indicating the
point characters of the \enumerate{
\item rejected $p$-values
\item non-rejected $p$-values
\item critical values (if present and \code{type.crit}
is a plot type like \code{'p'}, \code{'b'} etc.).
}}

\item{lwd}{numeric vector of length 3 indicating the thickness of the
points and lines; defaults to current \code{par()$lwd} setting
for all components.}

\item{cex}{numeric vector of length 3 indicating the size of point
characters or lines of the \enumerate{
\item rejected p-values
\item accepted p-values
\item critical values (if present).
}
defaults to current \code{par()$cex} setting for all components.}

\item{type.crit}{single character giving the type of plot desired for the
critical values (e.g.: \code{'p'}, \code{'l'} etc; see
\code{\link[graphics:plot.default]{graphics::plot.default()}}).}

\item{legend}{if \code{NULL}, no legend is plotted; otherwise expecting a
character string like \code{"topleft"} etc. or a numeric vector
of two elements indicating (x, y) coordinates.}

\item{...}{further arguments to \code{\link[graphics:plot.default]{graphics::plot.default()}}.}
}
\description{
Plots raw $p$-values of a \code{FDX} object and highlights rejected and
non-rejected $p$-values. If present, the critical values are plotted, too.
}
\details{
If \code{x} contains results of a weighted approach, the Y-axis of the plot
is derived from the weighted p-values. Otherwise, it is constituted by the
raw ones.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Construction of the p-values and their supports with Fisher's exact test
library(DiscreteTests)  # for Fisher's exact test
test.results <- fisher_test_pv(df)
raw.pvalues <- test.results$get_pvalues()
pCDFlist <- test.results$get_pvalue_supports()

# DLR without critical values; using extracted p-values and supports
DLR.sd.fast <- DLR(raw.pvalues, pCDFlist)
# plot with default settings
plot(DLR.sd.fast)

# DLR (step-up) with critical values; using test results object
DLR.su.crit <- DLR(test.results, direction = "su", critical.values = TRUE)
# limited plot range
plot(DLR.su.crit, xlim = c(1, 5), ylim = c(0, 0.4))

# DPB without critical values; using test results object
DPB.fast <- DPB(test.results)
# limited plot range, custom colors, line widths and point symbols, top-left legend 
plot(DPB.fast, col = c(2, 4), pch = c(2, 3), lwd = c(2, 2), 
     legend = "topleft", xlim = c(1, 5), ylim = c(0, 0.4))

# DGR with critical values; using extracted p-values and supports
DGR.crit <- DGR(raw.pvalues, pCDFlist, critical.values = TRUE)
# additional customized plot parameters
plot(DGR.crit, col = c(2, 4, 1), pch = c(1, 1, 4), lwd = c(1, 1, 2), 
     type.crit = 'o', legend = c(1, 0.4), lty = 1, xlim = c(1, 5), 
     ylim = c(0, 0.4), cex = c(3, 3, 2))

}
