% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.fe.prov.R
\name{test.fe.prov}
\alias{test.fe.prov}
\title{Hypothesis tests for fe.prov model object}
\usage{
test.fe.prov(data, fe.ls, Y.char, Z.char, prov.char, test = "score",
  null = "median", alpha = 0.05, n = 10000)
}
\arguments{
\item{data}{prepared \code{data.frame}. Use \code{\link{fe.data.prep}}}

\item{fe.ls}{fitted model object (fit using \code{fe.prov})}

\item{Y.char}{Y.char name of the response variable from \code{data} as a character string}

\item{Z.char}{Z.char names of covariates from \code{data} as vector of character strings}

\item{prov.char}{name of provider IDs variable as a character string}

\item{test}{string denoting hypothesis test to be conducted. Currently, options
include "exact.binom", "exact.poisbinom", "exact.bootstrap", "score". The default
is \code{test="score"}}

\item{null}{use median for null comparison}

\item{alpha}{alpha level for the CIs}

\item{n}{number of bootstrap draws}
}
\value{
Returns a \code{data.frame} of the results of the test for each provider
with attributes:
\itemize{
\item{flag:} Either "1" for p<alpha/2, "0" p<=1-alpha/2 and p<alpha/2, or "-1" for neither
\item{p:} p-value for the hypothesis test of the model parameter
}
}
\description{
\code{test.fe.prov} Conducts hypothesis tests for model parameter estimates.
First fit a \code{fe.prov} model object. Go to
\href{https://github.com/umich-biostatistics/FEprovideR}{Github} for a tutorial.
}
\examples{
# Name input variables and other parameters
# a small positive number specifying stopping
# criterion of Newton-Raphson algorithm
tol <- 1e-5
Y.char <- 'Y'
prov.char <- 'prov.ID'
Z.char <- paste0('z', 1:3)
data(hospital_prepared) # build in data set
fe.ls <- fe.prov(hospital_prepared, Y.char, Z.char, prov.char, tol) # model fitting

# Hypothesis tests
null = "median"
alpha = 0.05
score.fe <- test.fe.prov(hospital_prepared, fe.ls, Y.char, Z.char,
                         prov.char, test="score", null, alpha)

}
\references{
He, K., Kalbfleisch, J.D., Li, Y. and Li, Y., 2013. Evaluating hospital
readmission rates in dialysis facilities; adjusting for hospital effects. Lifetime data
analysis, 19(4), pp.490-512.
}
\seealso{
\code{\link{fe.data.prep}},  \code{\link{fe.prov}},
\code{\link{funnel.SRR}},   \code{\link{confint.fe.prov}}
}
